
-- @Author: Ragman2414
-- @Date: 02.12.2021
-- @Version: 1.0.0.0


ReduceMaintenanceSettings = {};
ReduceMaintenanceSettings.name = g_currentModName;
ReduceMaintenanceSettings.modDirectory = g_currentModDirectory

function ReduceMaintenanceSettings.init()

    InGameMenuGameSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGameSettingsFrame.onFrameOpen, ReduceMaintenanceSettings.initSettingsGui)
    --Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, ReduceMaintenanceSettings.loadSettingsXML)
    --FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, ReduceMaintenanceSettings.saveSettingsXML)

end

function ReduceMaintenanceSettings.initSettingsGui(self)
    ---Just check for maintenanceCost
    if self.maintenanceCost == nil then
        local target = g_r_maintenance
        self.maintenanceCost = self.economicDifficulty:clone()
        self.maintenanceCost.target = target
        self.maintenanceCost.id = "maintenanceCost"
        self.maintenanceCost.onClickCallback = ReduceMaintenanceSettings.onMaintenanceCostStateChanged
        self.maintenanceCost.buttonLRChange = ReduceMaintenanceSettings.onMaintenanceCostStateChanged
        self.maintenanceCost.texts[1] = "25 %"
        self.maintenanceCost.texts[2] = "50 %"
        self.maintenanceCost.texts[3] = "75 %"
        self.maintenanceCost.texts[4] = "100 %"
        self.maintenanceCost.texts[5] = "125 %"
        self.maintenanceCost.texts[6] = "150 %"

        local settingTitle = self.maintenanceCost.elements[4]
        local toolTip = self.maintenanceCost.elements[6]

        settingTitle:setText(ReduceMaintenanceSettings:getText("r_maintenance_cost"))
        toolTip:setText(ReduceMaintenanceSettings:getText("r_maintenance_cost_tooltip"))

        local state = 4
        if(g_r_maintenance.maintenanceCost ~= nil) then
            state = g_r_maintenance.maintenanceCost / 0.25
        end
        self.maintenanceCost:setState(state)

        --- Create MaintenanceDuration Element
        self.maintenanceDuration =  self.maintenanceCost:clone()
        self.maintenanceDuration.id = "maintenanceDuration"

        settingTitle = self.maintenanceDuration.elements[4]
        toolTip = self.maintenanceDuration.elements[6]

        settingTitle:setText(ReduceMaintenanceSettings:getText("r_maintenance_duration"))
        toolTip:setText(ReduceMaintenanceSettings:getText("r_maintenance_duration_tooltip"))
        state = 4
        if(g_r_maintenance.maintenanceDuration ~= nil) then
            state = g_r_maintenance.maintenanceDuration / 0.25
        end
        self.maintenanceDuration:setState(state)

        --- Create WearCost Element
        self.wearCost =  self.maintenanceCost:clone()
        self.wearCost.id = "wearCost"

        settingTitle = self.wearCost.elements[4]
        toolTip = self.wearCost.elements[6]

        settingTitle:setText(ReduceMaintenanceSettings:getText("r_wear_cost"))
        toolTip:setText(ReduceMaintenanceSettings:getText("r_wear_cost_tooltip"))
        state = 4
        if(g_r_maintenance.wearCost ~= nil) then
            state = g_r_maintenance.wearCost / 0.25
        end
        self.wearCost:setState(state)

        --- Create WearDuration Element
        self.wearDuration =  self.maintenanceCost:clone()
        self.wearDuration.id = "wearDuration"

        settingTitle = self.wearDuration.elements[4]
        toolTip = self.wearDuration.elements[6]

        settingTitle:setText(ReduceMaintenanceSettings:getText("r_wear_duration"))
        toolTip:setText(ReduceMaintenanceSettings:getText("r_wear_duration_tooltip"))
        state = 4
        if(g_r_maintenance.wearDuration ~= nil) then
            state = g_r_maintenance.wearDuration / 0.25
        end
        self.wearDuration:setState(state)

        local title = TextElement.new()
        title:applyProfile("settingsMenuSubtitle", true)
        title:setText(ReduceMaintenanceSettings:getText("r_maintenance_title"))

        self.boxLayout:addElement(title)
        self.boxLayout:addElement(self.maintenanceCost)
        self.boxLayout:addElement(self.maintenanceDuration)
        self.boxLayout:addElement(self.wearCost)
        self.boxLayout:addElement(self.wearDuration)
        self.boxLayout:invalidateLayout()
    end


end

function ReduceMaintenanceSettings:getText(key)
    return g_i18n.modEnvironments[ReduceMaintenanceSettings.name].texts[key]
end

function ReduceMaintenanceSettings:onMaintenanceCostStateChanged(state,x,y,z)
    g_client:getServerConnection():sendEvent(ChangeMaintenanceSettingsEvent.new(x.id, state))
end

ReduceMaintenanceSettings.init()