--
-- FSSE_HorseHelper
--
-- @Interface: 1.1.1.0 b14228
-- @Author: KR-Softwares
-- @Date: 19.12.2021
-- @Version: 1.0.0.0
--
-- @Support: www.kr-softwares.com
-- @Support: www.ls-modcompany.com
--
-- Changelog:
-- 	v1.0.0.0 (19.12.2021):
--      - Release
--

FSSE_HorseHelper = {}
FSSE_HorseHelper.price = 2

function FSSE_HorseHelper:hourChanged(org)
    return function(s, ...)
		org(s,...)						
		if g_currentMission.environment.currentHour == 23 then				
			if s.typeName == "horseHusbandry" then				
				local price = 0	
				for i, animal in pairs(s:getClusterSystem().clusters) do						
					price = price + ((100 - animal.riding) * FSSE_HorseHelper.price) + ((100 - animal.fitness) * FSSE_HorseHelper.price)
						+ (animal.dirt * FSSE_HorseHelper.price)
					animal.riding = 100
					animal.fitness = 100	
					animal.dirt = 0		
				end

				if g_server ~= nil then	
					if price > 0 then
						price = price / g_currentMission.environment.daysPerPeriod 
						g_currentMission:addMoney(-price, s.ownerFarmId, MoneyType.ANIMAL_UPKEEP, true, true)
					end
				end
			end
		end
	end
end

PlaceableHusbandry.onHourChanged = FSSE_HorseHelper:hourChanged(PlaceableHusbandry.onHourChanged)