manureFix = {}

function manureFix:updateOutput(of, superFunc, foodFactor, productionFactor, globalProductionFactor)
	if self.isServer then
		local spec = self.spec_husbandryStraw
		
		local fillLevel = self:getHusbandryFillLevel(spec.inputFillType)
		if fillLevel > 0 then
			if spec.inputLitersPerHour ~= 0 then
				local amount = spec.inputLitersPerHour * g_currentMission.environment.timeAdjustment
				local delta = amount - self:removeHusbandryFillLevel(self:getOwnerFarmId(), amount, spec.inputFillType)

				if spec.outputLitersPerHour > 0 then
					local liters = foodFactor * spec.outputLitersPerHour * g_currentMission.environment.timeAdjustment

					if liters > 0 then
						self:addHusbandryFillLevelFromTool(self:getOwnerFarmId(), liters, spec.outputFillType, nil, nil, nil)
					end
				end

				self:updateStrawPlane()
			end
		end
	end

	superFunc(self, foodFactor, productionFactor, globalProductionFactor)
end

PlaceableHusbandryStraw.updateOutput = Utils.overwrittenFunction(PlaceableHusbandryStraw.updateOutput, manureFix.updateOutput)