----------------------------------------------------------------------------
-- @Author: JTSage ---------------------------------------------------------
----------------------------------------------------------------------------

SiloFillPercentage = {};

function SiloFillPercentage:updateInfo(superFuncParent, superFunc, infoTable)

	local owningFarm     = g_farmManager:getFarmById(self:getOwnerFarmId())
	local spec           = self.spec_silo
	local farmId         = g_currentMission:getFarmId()
	local totalFillLevel = 0
	local totalCapacity  = 0

	local function quickPercentage(value, total)
		local rawPercent  = 0
		local goodPercent = 0

		if total > 0 then
			rawPercent = value / total * 100

			if rawPercent > 100 then
				goodPercent = 100
			elseif rawPercent < 0 then
				goodPercent = 0
			elseif rawPercent > 99 and value < total then
				goodPercent = 99
			elseif rawPercent < 1 and value > 0 then
				goodPercent = 1
			else
				goodPercent = math.floor(rawPercent + 0.5)
			end
		end
		return goodPercent
	end

	table.insert(infoTable, {
        title = g_i18n:getText("fieldInfo_ownedBy"),
        text  = owningFarm.name
    })

	for fillType, fillLevel in pairs(spec.loadingStation:getAllFillLevels(farmId)) do
		spec.fillTypesAndLevelsAuxiliary[fillType] = (spec.fillTypesAndLevelsAuxiliary[fillType] or 0) + fillLevel
		totalFillLevel                             = totalFillLevel + fillLevel
	end

	for _, sourceStorage in pairs(spec.loadingStation.sourceStorages) do
		if spec.loadingStation:hasFarmAccessToStorage(farmId, sourceStorage) then
			totalCapacity = totalCapacity + sourceStorage.capacity
		end
	end

	table.clear(spec.infoTriggerFillTypesAndLevels)

	for fillType, fillLevel in pairs(spec.fillTypesAndLevelsAuxiliary) do
		if fillLevel > 0.1 then
			spec.fillTypeToFillTypeStorageTable[fillType] = spec.fillTypeToFillTypeStorageTable[fillType] or {
				fillType  = fillType,
				fillLevel = fillLevel
			}
			spec.fillTypeToFillTypeStorageTable[fillType].fillLevel = fillLevel

			table.insert(spec.infoTriggerFillTypesAndLevels, spec.fillTypeToFillTypeStorageTable[fillType])
		end
	end

	table.clear(spec.fillTypesAndLevelsAuxiliary)
	table.sort(spec.infoTriggerFillTypesAndLevels, function (a, b)
		return b.fillLevel < a.fillLevel
	end)

	local numEntries = math.min(#spec.infoTriggerFillTypesAndLevels, PlaceableSilo.INFO_TRIGGER_NUM_DISPLAYED_FILLTYPES)

	if numEntries > 0 then
		for i = 1, numEntries do
			local fillTypeAndLevel = spec.infoTriggerFillTypesAndLevels[i]
			local thisTextLine     = tostring(g_i18n:formatVolume(fillTypeAndLevel.fillLevel, 0)) .. "  (" .. tostring(quickPercentage(fillTypeAndLevel.fillLevel, totalCapacity)) .. "%)"

			table.insert(infoTable, {
				title = g_fillTypeManager:getFillTypeTitleByIndex(fillTypeAndLevel.fillType),
				text  = thisTextLine
			})
		end
	end

	table.insert(infoTable, {
		title = "-",
		text  = tostring(math.floor(totalFillLevel)) .. " l / " ..tostring(totalCapacity) .. " l"
	})

	if numEntries < 1 then
		table.insert(infoTable, {
			text  = "",
			title = g_i18n:getText("infohud_siloEmpty")
		})
	end

	local totalPercentage = quickPercentage(totalFillLevel, totalCapacity)

	if totalPercentage > 0 then
		table.insert(infoTable, {
			title = "-",
			text  = tostring(totalPercentage) .. " % " .. g_i18n:getText("SiloFillPercentage_percFull")
		})
	end
	if totalPercentage > 98 then
		table.insert(infoTable, {
			title      = "-",
			text       = g_i18n:getText("SiloFillPercentage_isFull"),
			accentuate = true
		})
	end
end

PlaceableSilo.updateInfo = Utils.overwrittenFunction(PlaceableSilo.updateInfo, SiloFillPercentage.updateInfo);