--[[
Copyright (C) GtX (Andy), 2021

Author: GtX | Andy
Date: 12.04.2021
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


SupplyTransportMissionFinishedEvent = {}

local SupplyTransportMissionFinishedEvent_mt = Class(SupplyTransportMissionFinishedEvent, Event)
InitEventClass(SupplyTransportMissionFinishedEvent, "SupplyTransportMissionFinishedEvent")

function SupplyTransportMissionFinishedEvent.emptyNew()
    local self = Event.new(SupplyTransportMissionFinishedEvent_mt)

    return self
end

function SupplyTransportMissionFinishedEvent.new(supplyTranspostMission, success, reimbursement, stealingCost)
    local self = SupplyTransportMissionFinishedEvent.emptyNew()

    self.supplyTranspostMission = supplyTranspostMission
    self.success = success

    self.reimbursement = reimbursement
    self.stealingCost = stealingCost

    return self
end

function SupplyTransportMissionFinishedEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.supplyTranspostMission)
    streamWriteBool(streamId, self.success)

    if not self.success then
        streamWriteFloat32(streamId, self.reimbursement)
        streamWriteFloat32(streamId, self.stealingCost)
    end
end

function SupplyTransportMissionFinishedEvent:readStream(streamId, connection)
    self.supplyTranspostMission = NetworkUtil.readNodeObject(streamId)
    self.success = streamReadBool(streamId)

    if not self.success then
        self.reimbursement = streamReadFloat32(streamId)
        self.stealingCost = streamReadFloat32(streamId)
    end

    self:run(connection)
end

function SupplyTransportMissionFinishedEvent:run(connection)
    if connection:getIsServer() and self.supplyTranspostMission ~= nil then
        self.supplyTranspostMission.reimbursement = self.reimbursement
        self.supplyTranspostMission.stealingCost = self.stealingCost

        self.supplyTranspostMission:finish(self.success)
    end
end
