--[[
Copyright (C) GtX (Andy), 2021

Author: GtX | Andy
Date: 12.04.2021
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


local validationFail
local supplyTransportMissionManager

local modName = g_currentModName or ""
local modDirectory = g_currentModDirectory or ""

local buildId = 1
local versionString = "0.0.0.0"

local isDevelopmentVersion = false
local loadConsoleCommands = StartParams.getIsSet("consoleCommandsGtX")

local function getManagerInitiated()
    return supplyTransportMissionManager ~= nil
end

local function inGameMenuContractsFrame_update(frame, dt)
    local contract = frame:getSelectedContract()

    if contract ~= nil and contract.mission:isa(SupplyTransportMission) and not frame.supplyTransportMissionUpdating then
        if contract.mission.getRemainingTime ~= nil then
            frame.fieldBigText:setText(contract.mission:getRemainingTime(true))
        end
    end
end

local function inGameMenuContractsFrame_updateDetailContents(frame, contractSection, contractIndex)
    local sectionContracts = frame.sectionContracts[contractSection]

    if sectionContracts ~= nil then
        local contract = sectionContracts.contracts[contractIndex]

        if contract ~= nil then
            local mission = contract.mission

            if mission ~= nil and mission:isa(SupplyTransportMission) then
                if contract.finished then
                    local reimbursement = mission.reimbursement or 0

                    if reimbursement > 0 then
                        local total = reimbursement

                        if mission.stealingCost ~= nil then
                            total = total + (mission.stealingCost * -1)
                        end

                        frame.tallyBox:getDescendantByName("reimburse"):setText(g_i18n:formatMoney(reimbursement, 0, true, true))
                        frame.tallyBox:getDescendantByName("total"):setText(g_i18n:formatMoney(total, 0, true, true))
                    end
                else
                    if mission.missingProductWarning ~= nil then
                        if contract.possible then
                            frame.useOwnEquipementText:setVisible(true)
                            frame.useOwnEquipementText:setText(mission.missingProductWarning)
                        elseif contract.active then
                            frame.extraProgressText:setText(mission.missingProductWarning)
                        end
                    end
                end
            end
        end
    end
end

local function inGameMenuContractsFrame_updateFieldContractInfo(frame, superFunc, mission)
    if not mission:isa(SupplyTransportMission) then
        superFunc(frame, mission)
    else
        frame.supplyTransportMissionUpdating = true

        local missionInfo = mission:getData()

        frame.titleText:setText(g_i18n:getText("fieldJob_contract") .. ": " .. missionInfo.jobType)
        frame.actionText:setText(missionInfo.action)
        frame.rewardText:setText(g_i18n:formatMoney(mission.reward, 0, true, true))
        frame.fieldBigText:setText(missionInfo.timeLimit or "")
        frame.contractDescriptionText:setText(missionInfo.description)
        frame.supplyTransportMissionUpdating = false
    end
end

local function missionManager_loadMapData(missionManager, xmlFile)
    if getManagerInitiated() then
        supplyTransportMissionManager:loadMapData(missionManager, xmlFile)

        -- Overwrite 'updateFieldContractInfo' late in case other mods fail to return superFunc as in FS19
        InGameMenuContractsFrame.update = Utils.appendedFunction(InGameMenuContractsFrame.update, inGameMenuContractsFrame_update)
        InGameMenuContractsFrame.updateDetailContents = Utils.appendedFunction(InGameMenuContractsFrame.updateDetailContents, inGameMenuContractsFrame_updateDetailContents)
        InGameMenuContractsFrame.updateFieldContractInfo = Utils.overwrittenFunction(InGameMenuContractsFrame.updateFieldContractInfo, inGameMenuContractsFrame_updateFieldContractInfo)
    end
end

local function missionManager_unloadMapData(missionManager)
    missionManager.supplyTransportMissionManager = nil

    if getManagerInitiated() then
        supplyTransportMissionManager:unloadMapData()
        supplyTransportMissionManager = nil
    end
end

local function missionManager_loadFromXMLFile(missionManager, superFunc, xmlFilename)
    if not superFunc(missionManager, xmlFilename) then
        return false
    end

    if getManagerInitiated() then
        local xmlFile = loadXMLFile("missionsXML", xmlFilename)

        if xmlFile ~= nil then
            supplyTransportMissionManager:setMaxMissions(getXMLInt(xmlFile, "missions#maxSupplyTransportContracts"))

            delete(xmlFile)
        end

        for _, mission in ipairs (missionManager.missions) do
            if mission:isa(SupplyTransportMission) then
                supplyTransportMissionManager:addMissionToList(mission)
            end
        end
    end

    return true
end

local function missionManager_saveToXMLFile(missionManager, superFunc, xmlFilename)
    local success = superFunc(missionManager, xmlFilename)

    if getManagerInitiated() then
        local xmlFile = loadXMLFile("missionsXML", xmlFilename)

        if xmlFile ~= nil then
            setXMLInt(xmlFile, "missions#maxSupplyTransportContracts", supplyTransportMissionManager:getMaxMissions())

            saveXMLFile(xmlFile)
            delete(xmlFile)
        end
    end

    return success
end

local function missionManager_generateMissions(missionManager, dt)
    if getManagerInitiated() then
        supplyTransportMissionManager:generateMissions(dt)
    end
end

local function missionManager_updateMissions(missionManager, dt)
    if getManagerInitiated() then
        supplyTransportMissionManager:updateMissions(dt)
    end
end

local function missionManager_removeMissionFromList(missionManager, mission)
    if getManagerInitiated() then
        if mission ~= nil and mission.type.category == SupplyTransportMission.CATEGORY then
            supplyTransportMissionManager:removeMissionFromList(mission)
        end
    end
end

local function init()
    if g_missionManager ~= nil then
        if g_missionManager.supplyTransportMissionManager == nil then
            local mod = g_modManager:getModByName(modName)
            local isValidMod = false

            versionString = mod.version or versionString

            if mod.modName == "FS22_SupplyTransportContracts" or mod.modName == "FS22_SupplyTransportContracts_update" then
                if mod.author ~= nil and #mod.author == 3 then
                    isValidMod = true
                end
            end

            if isValidMod then
                source(modDirectory .. "scripts/SupplyTransportMissionManager.lua")
                source(modDirectory .. "scripts/SupplyTransportMission.lua")
                source(modDirectory .. "scripts/events/SupplyTranspostMissionFinishedEvent.lua")

                MissionManager.loadMapData = Utils.prependedFunction(MissionManager.loadMapData, missionManager_loadMapData)
                MissionManager.unloadMapData = Utils.prependedFunction(MissionManager.unloadMapData, missionManager_unloadMapData)
                MissionManager.loadFromXMLFile = Utils.overwrittenFunction(MissionManager.loadFromXMLFile, missionManager_loadFromXMLFile)
                MissionManager.saveToXMLFile = Utils.overwrittenFunction(MissionManager.saveToXMLFile, missionManager_saveToXMLFile)
                MissionManager.generateMissions = Utils.appendedFunction(MissionManager.generateMissions, missionManager_generateMissions)
                MissionManager.updateMissions = Utils.appendedFunction(MissionManager.updateMissions, missionManager_updateMissions)
                MissionManager.removeMissionFromList = Utils.appendedFunction(MissionManager.removeMissionFromList, missionManager_removeMissionFromList)

                supplyTransportMissionManager = SupplyTransportMissionManager.new(g_server ~= nil, g_client ~= nil, buildId, versionString, loadConsoleCommands, modName, modDirectory, g_missionManager)

                if supplyTransportMissionManager ~= nil then
                    supplyTransportMissionManager:setIsDevelopmentVersion(isDevelopmentVersion)
                    g_missionManager.supplyTransportMissionManager = supplyTransportMissionManager
                end
            else
                validationFail = {
                    startUpdateTime = 2000,

                    update = function(self, dt)
                        self.startUpdateTime = self.startUpdateTime - dt

                        if self.startUpdateTime < 0 then
                            local text = string.format(g_i18n:getText("supplyTransport_loadError", modName), modName, mod.author or "Unknown")

                            if g_dedicatedServerInfo == nil then
                                if not g_gui:getIsGuiVisible() then
                                    g_gui:showYesNoDialog({
                                        title = string.format("%s - Version %s", mod.title, versionString),
                                        text = text,
                                        dialogType = DialogElement.TYPE_LOADING,
                                        callback = self.openModHubLink,
                                        yesText = g_i18n:getText("button_ok"),
                                        noText = g_i18n:getText("button_modHubDownload")
                                    })
                                end
                            else
                                print("\n" .. text .. "\n    - https://farming-simulator.com/mods.php?lang=en&country=be&title=fs2022&filter=org&org_id=129652&page=0" .. "\n")
                                self.openModHubLink(true)
                            end
                        end
                    end,

                    openModHubLink = function(ignore)
                        if ignore == false then
                            local language = g_languageShort
                            local link = "mods.php?lang=en&country=be&title=fs2022&filter=org&org_id=129652&page=0"
                            if language == "de" or language == "fr" then
                                link = "mods.php?lang=" .. language .. "&country=be&title=fs2022&filter=org&org_id=129652&page=0"
                            end

                            openWebFile(link, "")
                        end

                        removeModEventListener(validationFail)
                        validationFail = nil
                    end
                }

                addModEventListener(validationFail)
            end
        else
            Logging.error("Failed to load mod '%s', 'SupplyTransportMissionManager' was already loaded by '%s'!", modName, g_missionManager.supplyTransportMissionManager.modName or "N/A")
        end
    else
        Logging.warning("MissionManager failed to load, unable to initiate 'SupplyTransportMissionManager'!")
    end
end

init()
