---@class ChangeableDischargeFillUnitChangeEvent
ChangeableDischargeFillUnitChangeEvent = {}

local ChangeableDischargeFillUnitChangeEvent_mt = Class(ChangeableDischargeFillUnitChangeEvent, Event)

InitEventClass(ChangeableDischargeFillUnitChangeEvent, "ChangeableDischargeFillUnitChangeEvent")

---@return ChangeableDischargeFillUnitChangeEvent
function ChangeableDischargeFillUnitChangeEvent.emptyNew()
    local self = Event.new(ChangeableDischargeFillUnitChangeEvent_mt)
    return self
end

function ChangeableDischargeFillUnitChangeEvent.new(object, unitIndex)
    local self = ChangeableDischargeFillUnitChangeEvent.emptyNew()

    self.object = object
    self.unitIndex = unitIndex

    return self
end

function ChangeableDischargeFillUnitChangeEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.unitIndex = streamReadUInt8(streamId)
    self:run(connection)
end

function ChangeableDischargeFillUnitChangeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUInt8(streamId, self.unitIndex)
end

function ChangeableDischargeFillUnitChangeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end

    self.object:setDischargeFillUnit(self.unitIndex, true)
end

function ChangeableDischargeFillUnitChangeEvent.sendEvent(object, unitIndex, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(ChangeableDischargeFillUnitChangeEvent.new(object, unitIndex), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(ChangeableDischargeFillUnitChangeEvent.new(object, unitIndex))
        end
    end
end
